<?php

namespace App\Http\Controllers;

use App\Models\Pendaftaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Storage;

class PendaftaranController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $pendaftaran = Pendaftaran::where('user_id', $user->id)->first();
        if ($pendaftaran) {
            return view('pendaftaran.index', compact('pendaftaran'));
        } else {
            return view('pendaftaran.index');
        }
    }

    public function allData()
    {
        $pendaftaran = Pendaftaran::all();
        return view('pendaftaran.master', compact('pendaftaran'));
    }

    public function store(Request $request)
    {
        try {
            $data = $request->all();
            $data['user_id'] = Auth::user()->id;
            $data['tanggal_lahir'] = date('Y-m-d', strtotime($data['tanggal_lahir']));
            $data['status'] = 'pending';

            if ($request->hasFile('pas_photo')) {
                $file = $request->file('pas_photo');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/pas_photo', $filename);
                $data['pas_photo'] = 'pas_photo/'.$filename;
            }

            Pendaftaran::create($data);
            Alert::success('Success', 'Pendaftaran berhasil');
            return redirect()->route('pendaftaran.index');

        } catch(\Exception $e) {
            Alert::error('Error', 'Pendaftaran gagal');
            return redirect()->route('pendaftaran.index');
        }
    }

    public function edit(Pendaftaran $pendaftaran)
    {
        $data = Pendaftaran::find($pendaftaran->id);
        return view('pendaftaran.edit-pendaftaran', compact('data'));
    }

    public function update(Request $request, $id) : RedirectResponse
    {
        try {
            $data = $request->all();
            $data['tanggal_lahir'] = date('Y-m-d', strtotime($data['tanggal_lahir']));

            $pendaftaran = Pendaftaran::where('id', $id)->first();
            $pathfoto = $pendaftaran->pas_photo;

            if ($request->hasFile('pas_photo')) {
                if ($pathfoto) {
                    Storage::disk('public')->delete($pathfoto);
                }

                $file = $request->file('pas_photo');
                $filename = time() . '.' . $file->getClientOriginalExtension();
                $file->storeAs('public/pas_photo', $filename);
                $data['pas_photo'] = 'pas_photo/'.$filename;
            } else {
                unset($data['pas_photo']);
            }

            $pendaftaran->update($data);
            Alert::success('Success', 'Pendaftaran berhasil diubah');
            return redirect()->route('pendaftaran.all');

        } catch(\Exception $e) {
            Alert::error('Error', 'Pendaftaran gagal diubah');
            return redirect()->route('pendaftaran.all');
        }
    }

    public function destroy($id)
    {
        try {
            $pendaftaran = Pendaftaran::where('id', $id)->first();
            $pathfoto = $pendaftaran->pas_photo;

            if ($pathfoto) {
                Storage::disk('public')->delete($pathfoto);
            }

            $pendaftaran->delete();
            Alert::success('Success', 'Pendaftaran berhasil dihapus');
            return redirect()->route('pendaftaran.all');

        } catch(\Exception $e) {
            Alert::error('Error', 'Pendaftaran gagal dihapus');
            return redirect()->route('pendaftaran.all');
        }
    }
}
