<x-guest-layout>
    <div class="flex items-center justify-center bg-gray-100 dark:bg-gray-900 md:flex-col">
        <!-- Wrapper Container -->
        <div class="flex flex-row w-full max-w-6xl bg-white dark:bg-gray-800 shadow-md rounded-lg overflow-hidden">

            <!-- Gambar di kiri -->
            <div class="w-1/2 hidden md:block">
                <img src="{{ asset('images/vector-login.png') }}" alt="Login Illustration" class="w-full h-full object-cover">
            </div>

            <!-- Form Login di kanan -->
            <div class="w-full lg:p-8 md:w-1/2 p-2 flex flex-col justify-center">
                <!-- Session Status -->
                <x-auth-session-status class="mb-4" :status="session('status')" />

                {{-- Header --}}
                <h1 class="text-4xl font-extrabold text-center text-gray-900 dark:text-gray-100">MI AL-AMIEN</h1>
                <h3 class="mb-6 text-1xl font-extrabold text-center text-gray-900 dark:text-gray-100">
                    {{ __('Selamat Datang dan Silahkan Masuk') }}
                </h2>

                <form method="POST" action="{{ route('login') }}">
                    @csrf

                    <!-- Email Address -->
                    <div>
                        <x-input-label for="email" :value="__('Email')" />
                        <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" />
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <!-- Password -->
                    <div class="mt-4">
                        <x-input-label for="password" :value="__('Kata Sandi')" />
                        <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="current-password" />
                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <!-- Remember Me -->
                    <div class="block mt-4">
                        <label for="remember_me" class="inline-flex items-center">
                            <input id="remember_me" type="checkbox" class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800" name="remember">
                            <span class="ms-2 text-sm text-gray-600 dark:text-gray-400">{{ __('Ingat Saya!') }}</span>
                        </label>
                    </div>

                    <div class="flex flex-row items-center justify-end mt-4">
                        @if (Route::has('password.request'))
                            <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800" href="{{ route('password.request') }}">
                                {{ __('Lupa Kata Sandi?') }}
                            </a>
                        @endif

                        <x-primary-button class="ms-3">
                            {{ __('Masuk') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-guest-layout>
