@props(['guru'])

<div class="max-w-sm rounded overflow-hidden shadow-lg text-center mx-auto">
    <img class="object-cover h-56 w-56 rounded-full" src="{{ asset('storage/'.$guru->foto) }}" alt="{{ $guru->nama }}">
    <div class="px-6 py-4">
        <div class="font-bold text-center text-white text-xl mb-2">{{ $guru->nama }}</div>
        <p class="text-white text-base">
            {{ $guru->kelas->nama_kelas }}
        </p>
    </div>
    <div class="px-6 pt-4 pb-2">
        <span class="inline-block {{ $guru->jenis_kelamin == 'Perempuan' ? 'bg-green-300' : 'bg-red-300' }} rounded-full px-3 py-1 text-sm font-semibold text-gray-700 mr-2 mb-2">{{ $guru->jenis_kelamin }}</span>
        @if($guru->no_hp)
            <span class="inline-block bg-gray-200 rounded-full px-3 py-1 text-sm font-semibold text-gray-700 mr-2 mb-2">{{ $guru->no_hp }}</span>
        @endif
    </div>
</div>
