@props(['item'])

<div class="max-w-sm rounded overflow-hidden shadow-lg">
    <a href="{{ route('informasis.show', ['informasi' => $item->slug]) }}">
        <img class="object-cover h-48 w-96" src="{{ asset('storage/'.$item->gambar) }}" alt="{{ $item->judul }}">
        <div class="px-6 py-4">
            <div class="font-bold text-xl mb-2">
                {{ Str::limit($item->judul, 20) }}
                {{-- SPan Tag Kategori dengan background random color --}}
                <span class=" {{
                    $item->kategori == 'ARTIKEL' ? 'bg-yellow-200'
                    : ($item->kategori == 'BERITA' ? 'bg-blue-300'
                    : ($item->kategori == 'KEGIATAN' ? 'bg-green-200'
                    : ($item->kategori == 'AKADEMIK' ? 'bg-red-200'
                    : 'bg-gray-200')))
                    }} text-gray-700 text-xs font-bold py-1 px-2 rounded-full float-right">
                    {{ $item->kategori }}
                </span>
            </div>
            <p class="text-white-700 text-base">
                {{ Str::limit($item->deskripsi, 200) }}
            </p>
            <p class="text-gray-500 text-sm mt-2 text-right">Published: {{ $item->created_at }}</p>
        </div>
    </a>
</div>
