<section>
    <header>
        <h2 id="form-title" class="text-lg font-medium text-gray-900 dark:text-gray-100">
            {{ __('Tambah Guru') }}
        </h2>

        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
            {{ __("Kelola Daftar Guru") }}
        </p>
    </header>

    <form id="guru-form" method="POST" action="{{ route('guru.store') }}" enctype="multipart/form-data">
        @csrf
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div class="mt-6 space-y-6">
                <input type="hidden" id="guru-id" name="guru_id" value="">
                {{-- Kelas --}}
                <div>
                    <x-input-label for="kelas" :value="__('Kelas')" />
                    <select id="kelas" name="kelas_id" class="mt-1 block w-full" required>
                        <option value="">Pilih Kelas</option>
                        @foreach ($kelas as $item)
                            <option value="{{ $item->id }}">{{ $item->nama_kelas }}</option>
                        @endforeach
                    </select>
                    <x-input-error class="mt-2" :messages="$errors->get('kelas')" />
                </div>

                {{-- Nama --}}
                <div>
                    <x-input-label for="nama" :value="__('Nama Guru')" />
                    <x-text-input id="nama" name="nama" type="text" class="mt-1 block w-full" required autofocus autocomplete="nama" />
                    <x-input-error class="mt-2" :messages="$errors->get('nama')" />
                </div>

                {{-- NIP --}}
                <div>
                    <x-input-label for="nip" :value="__('NIP')" />
                    <x-text-input id="nip" name="nip" type="text" class="mt-1 block w-full" required autocomplete="nip" />
                    <x-input-error class="mt-2" :messages="$errors->get('nip')" />
                </div>

                {{-- Jenis Kelamin --}}
                <div>
                    <x-input-label for="jenis_kelamin" :value="__('Jenis Kelamin')" />
                    <select id="jenis_kelamin" name="jenis_kelamin" class="mt-1 block w-full" required>
                        <option value="">Pilih Jenis Kelamin</option>
                        <option value="Laki-laki">Laki-laki</option>
                        <option value="Perempuan">Perempuan</option>
                    </select>
                    <x-input-error class="mt-2" :messages="$errors->get('jenis_kelamin')" />
                </div>

                {{-- Alamat --}}
                <div>
                    <x-input-label for="alamat" :value="__('Alamat')" />
                    <x-text-input id="alamat" name="alamat" type="text" class="mt-1 block w-full" required autocomplete="alamat" />
                    <x-input-error class="mt-2" :messages="$errors->get('alamat')" />
                </div>

                {{-- No Hp --}}
                <div>
                    <x-input-label for="no_hp" :value="__('No Hp')" />
                    <x-text-input id="no_hp" name="no_hp" type="text" class="mt-1 block w-full" required autocomplete="no_hp" />
                    <x-input-error class="mt-2" :messages="$errors->get('no_hp')" />
                </div>
            </div>
            <div>
                <header>
                    <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                        {{ __('Upload Photo') }}
                    </h2>

                    <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                        {{ __("Upload foto Tenaga Pengajar.") }}
                    </p>
                </header>
                {{-- Upload Photo --}}
                <div>
                    <x-input-label for="foto" :value="__('Pas Photo')" />
                    <x-file-input id="foto" name="foto" class="mt-1 block w-full" />
                    <x-input-error class="mt-2" :messages="$errors->get('foto')" />
                </div>

                <div class="mt-4">
                    <img id="preview-foto" src="" alt=" Foto Profil" class="h-40 text-gray-300 rounded-lg">
                </div>
            </div>
        </div>

        <div class="flex items-center gap-4 mt-6 space-y-6">
            <x-primary-button id="form-button">{{ __('Tambah') }}</x-primary-button>
        </div>
    </form>

    <script>
        document.getElementById('foto').addEventListener('change', function(event) {
            var file = event.target.files[0];
            var reader = new FileReader();

            reader.onload = function(e) {
                document.getElementById('preview-foto').src = e.target.result;
                document.getElementById('preview-foto').style.height = '300px';
            };

            reader.readAsDataURL(file);
        });
    </script>
</section>
