<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'PPDB') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        {{-- icon mdi --}}
        <link href="https://cdn.jsdelivr.net/npm/@mdi/font/css/materialdesignicons.min.css" rel="stylesheet">

        <link href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" rel="stylesheet">
        <link href="https://cdn.datatables.net/1.11.5/css/dataTables.tailwind.min.css" rel="stylesheet">

        <style>
        .dataTables_wrapper {
            padding: 10px;
        }
        /* Additional custom styles for dark theme */
        .dataTables_length, .dataTables_wrapper .dataTables_filter,
        .dataTables_wrapper .dataTables_info, .dataTables_wrapper
        .dataTables_processing, .dataTables_wrapper .dataTables_paginate
        {
            color: white !important;
        }

        .dataTables_length select, .dataTables_filter input
        {
            background-color: #4b5563 !important;
            color: white !important;
        }

        ::-webkit-scrollbar {
                width: 0;
                background: transparent;
            }

            /* For Firefox */
            * {
                scrollbar-color: transparent transparent; /* Firefox */
                scrollbar-width: thin;
            }

            /* For IE and Edge */
            * {
                -ms-overflow-style: -ms-autohiding-scrollbar;
            }
        </style>

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased">
        <!-- ... -->
        @include('sweetalert::alert')
        <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @isset($header)
                <header class="bg-white dark:bg-gray-800 shadow">
                    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </header>
            @endisset

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>
        </div>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
        <script>
            $(document).ready(function() {
                $('#dataTables').DataTable({
                    "pagingType": "simple_numbers", // Customize paging type
                    "language": {
                        "search": "Cari:", // Customize search placeholder
                        "lengthMenu": "Tampilkan _MENU_ data per halaman",
                        "info": "Menampilkan _START_ sampai _END_ dari _TOTAL_ data",
                        "paginate": {
                            "first": "Pertama",
                            "last": "Terakhir",
                            "next": "Berikutnya",
                            "previous": "Sebelumnya"
                        }
                    },
                    "drwaCallback": function() {
                        // tulisan search infi, paginate ubah ke warna putih
                        $(".dataTables_paginate").addClass("text-white p-4");
                        $(".dataTables_paginate .paginate_button").addClass("text-white");
                    },
                });
            });
        </script>
    </body>
</html>
