<form method="POST" action="{{ route('pendaftaran.store') }}" enctype="multipart/form-data">
    @csrf
    @include('pendaftaran.partials.upload-photo')
    {{-- Gari Horizontal --}}
    <div class="border-t border-gray-900 dark:border-gray-100 mt-4 mb-4"></div>
    {{-- Form Pendaftaran --}}
    <section>
        <header>
            <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                <i class="mdi mdi-numeric-2-circle"></i>
                {{ __('Form Pendaftaran') }}
            </h2>

            <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                {{ __("Lengkapi Forms Pendaftaran dibawah ini sesuai dengan data diri siswa.") }}
            </p>
        </header>

        <div class="mt-6 space-y-6">
            {{-- NIK --}}
            <div>
                <x-input-label for="nik" :value="__('NIK')" />
                <x-text-input id="nik" name="nik" type="text" class="mt-1 block w-full" required autofocus
                    autocomplete="nik" />
                <x-input-error class="mt-2" :messages="$errors->get('nik')" />
            </div>

            {{-- Nama Lengkap --}}
            <div>
                <x-input-label for="nama" :value="__('Nama Lengkap')" />
                <x-text-input id="nama" name="nama" type="text" class="mt-1 block w-full" required autofocus
                    autocomplete="nama" />
                <x-input-error class="mt-2" :messages="$errors->get('nama')" />
            </div>

            {{-- Jenis Kelamin --}}
            <div>
                <x-input-label for="jenis_kelamin" :value="__('Jenis Kelamin')" />
                <select id="jenis_kelamin" name="jenis_kelamin" class="mt-1 block
                    w-full rounded-md shadow-sm border-gray-300 focus:border-primary-300 focus:ring focus:ring-primary-200
                    focus:ring-opacity-50 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-600 dark:focus:border-primary-600"
                    required>
                    <option value="">Pilih Jenis Kelamin</option>
                    <option value="Laki-laki">Laki-laki</option>
                    <option value="Perempuan">Perempuan</option>
                </select>
                <x-input-error class="mt-2" :messages="$errors->get('jenis_kelamin')" />
            </div>

            {{-- Tempat Lahir --}}
            <div>
                <x-input-label for="tempat_lahir" :value="__('Tempat Lahir')" />
                <x-text-input id="tempat_lahir" name="tempat_lahir" type="text" class="mt-1 block w-full" required
                    autofocus autocomplete="tempat_lahir" />
                <x-input-error class="mt-2" :messages="$errors->get('tempat_lahir')" />
            </div>

            {{-- Tanggal Lahir --}}
            <div>
                <x-input-label for="tanggal_lahir" :value="__('Tanggal Lahir')" />
                <x-text-input id="tanggal_lahir" name="tanggal_lahir" type="date" class="mt-1 block w-full" required
                    autofocus autocomplete="tanggal_lahir" placeholder="yyyy/mm/dd" pattern="\d{4}/\d{2}/\d{2}" />
                <x-input-error class="mt-2" :messages="$errors->get('tanggal_lahir')" />
            </div>

            {{-- Alamat --}}
            <div>
                <x-input-label for="alamat" :value="__('Alamat')" />
                <x-text-input id="alamat" name="alamat" type="text" class="mt-1 block w-full" required autofocus
                    autocomplete="alamat" />
                <x-input-error class="mt-2" :messages="$errors->get('alamat')" />
            </div>

            {{-- No Telpon Orang Tua --}}
            <div>
                <x-input-label for="no_hp" :value="__('No Telpon Orang Tua')" />
                <x-text-input id="no_hp" name="no_hp" type="text" class="mt-1 block w-full" required autofocus
                    autocomplete="no_hp" />
                <x-input-error class="mt-2" :messages="$errors->get('no_hp')" />
            </div>

            <div class="flex items-center gap-4">
                <x-primary-button>{{ __('Daftar') }}</x-primary-button>
                @if (session('status') === 'Pendaftaraan-Sukses')
                    <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)"
                        class="text-sm text-gray-600 dark:text-gray-400">{{ __('Saved.') }}
                    </p>
                @endif
            </div>
        </div>
    </section>
</form>
