<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>PPDB | AL-AMIEN</title>

    
    <link rel="icon" href="<?php echo e(asset('img/logo.png')); ?>" type="image/png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"/>

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <!-- Styles -->
    <style>
        /* Hilangkan scrollbar */
        ::-webkit-scrollbar {
            width: 0;
            background: transparent;
        }

        * {
            scrollbar-color: transparent transparent;
            scrollbar-width: thin;
            -ms-overflow-style: -ms-autohiding-scrollbar;
        }

        /* Tambahkan background full */
        body {
            background-image: url('https://img.freepik.com/premium-vector/vector-wave-lines-flowing-dynamic-colorful-blue-pink-isolated-black-background-concept-ai-technology-digital-communication-science-music_249611-21777.jpg?semt=ais_hybrid&w=740');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            background-attachment: fixed;
        }

        /* Lapisan transparan untuk konten */
        .content-overlay {
            background-color: rgba(255, 255, 255, 0.85); /* Ubah sesuai kebutuhan */
        }

        @media (prefers-color-scheme: dark) {
            .content-overlay {
                background-color: rgba(0, 0, 0, 0.30);
            }
        }
    </style>
</head>
<body class="font-sans antialiased dark:bg-black dark:text-white/50">
    <div class="min-h-screen content-overlay">
        <div class="relative min-h-screen flex flex-col items-center justify-center selection:bg-[#FF2D20] selection:text-white">
            <div class="relative w-full max-w-2xl px-6 lg:max-w-7xl">
                <header class="flex items-center py-10">
                    <div class="flex">
                        <span class="text-xl text-black dark:text-white">PPDB | Penerimaan Peserta Didik Baru</span>
                    </div>
                    <button id="toggleNavButton" class="block flex space-x-3 flex-1 justify-end md:hidden">
                        <i class="fas fa-bars"></i>
                    </button>
                    <?php if(Route::has('login')): ?>
                        <nav id="mainNav" class="hidden md:flex flex-1 md:space-x-3 md:justify-end">
                            <?php if(auth()->guard()->check()): ?>
                                <a href="<?php echo e(url('/dashboard')); ?>" class="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white">
                                    Dashboard
                                </a>
                            <?php else: ?>
                                <a href="/" class="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white">
                                    Beranda
                                </a>
                                <a href="<?php echo e(route('login')); ?>" class="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white">
                                    Masuk
                                </a>
                                <?php if(Route::has('register')): ?>
                                    <a href="<?php echo e(route('register')); ?>" class="rounded-md px-3 py-2 text-black ring-1 ring-transparent transition hover:text-black/70 focus:outline-none focus-visible:ring-[#FF2D20] dark:text-white dark:hover:text-white/80 dark:focus-visible:ring-white">
                                        Daftar Akun
                                    </a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </nav>
                    <?php endif; ?>
                </header>

                <?php if(isset($titleHeader)): ?>
                    <div class="flex flex-col justify-center text-black dark:text-white">
                        <h1 class="text-4xl font-bold"><?php echo e($titleHeader); ?></h1>
                        <p><?php echo e($subTitle); ?></p>
                    </div>
                <?php endif; ?>

                <main class="mt-6">
                    <?php echo e($slot); ?>

                </main>

                <footer class="py-16 text-center text-sm text-black dark:text-white/70">
                   MI AL-AMIEN &copy; 2025
                </footer>
            </div>
        </div>
    </div>

    <script>
        // Toggle nav menu on mobile
        const toggleNavButton = document.getElementById('toggleNavButton');
        const mainNav = document.getElementById('mainNav');

        toggleNavButton.addEventListener('click', function() {
            mainNav.classList.toggle('hidden');
        });
    </script>
</body>
</html>
<script>
    // Menggunakan Alpine.js untuk mengelola state dark mode
    document.addEventListener('alpine:init', () => {
        Alpine.data('darkMode', () => ({
            isDark: false,
            init() {
                this.isDark = localStorage.getItem('darkMode') === 'true';
                if (this.isDark) {
                    document.documentElement.classList.add('dark');
                }
            },
            toggle() {
                this.isDark = !this.isDark;
                localStorage.setItem('darkMode', this.isDark);
                document.documentElement.classList.toggle('dark', this.isDark);
            }
        }));
    });
</script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/alpinejs/3.10.5/cdn.min.js" defer></script>
<?php /**PATH C:\laragon\www\ppdb\resources\views/layouts/front.blade.php ENDPATH**/ ?>