<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900 dark:text-gray-100">
            <?php echo e(__('Status Pendaftaran')); ?>

        </h2>

        
        <?php if($pendaftaran->status == 'pending'): ?>
            <div class="items center gap-2 mt-2">
                
                <i class="mdi mdi-loading mdi-spin text-yellow-500" style="font-size: 4rem"></i> <br/>
                <p class="text-yellow-500">SEDANG DIPERIKSA, CEK KEMBALI DILAIN WAKTU</p>
            </div>
        <?php elseif($pendaftaran->status == 'approved'): ?>
            <div class="flex items center gap-2 mt-2">
                <i class="mdi mdi-check-circle text-green-500"></i>
                <span class="text-green-500">DITERIMA</span>
            </div>
        <?php elseif($pendaftaran->status == 'rejected'): ?>
            <div class="flex items center gap-2 mt-2">
                <i class="mdi mdi-close-circle text-red-500"></i>
                <span class="text-red-500">DITOLAK</span>
            </div>
        <?php else: ?>
            <div class="flex items center gap-2 mt-2">
                <i class="mdi mdi-close-circle text-red-500"></i>
                <span class="text-red-500">ANDA BELUM MENDAFTAR, SILAHKAN UNTUK MENDAFTAR</span>
            </div>
        <?php endif; ?>
    </header>

    <div class="mt-6 text-white">
        <img src="<?php echo e(asset('storage/'.$pendaftaran->pas_photo)); ?>" alt="<?php echo e($pendaftaran->nama); ?>" class="
            w-40 h-48 rounded object-cover
            border-2 border-white
            shadow-lg mb-4
        ">
        <h2 class="flex"><span class="w-40">NIK</span>: <span> &nbsp;<?php echo e($pendaftaran->nik); ?></span></h2>
        <h2 class="flex"><span class="w-40">Nama</span>: <span> &nbsp;<?php echo e($pendaftaran->nama); ?></span></h2>
        <h2 class="flex"><span class="w-40">Jenis Kelamin</span>: <span> &nbsp;<?php echo e($pendaftaran->jenis_kelamin); ?></span></h2>
        <h2 class="flex"><span class="w-40">Tempat Lahir</span>: <span> &nbsp;<?php echo e($pendaftaran->tempat_lahir); ?></span></h2>
        <h2 class="flex"><span class="w-40">Tanggal Lahir</span>: <span> &nbsp;<?php echo e($pendaftaran->tanggal_lahir); ?></span></h2>
        <h2 class="flex"><span class="w-40">Alamat</span>: <span> &nbsp;<?php echo e($pendaftaran->alamat); ?></span></h2>
    </div>
</section>
<?php /**PATH C:\laragon\www\ppdb\resources\views/pendaftaran/partials/status-pendaftaran.blade.php ENDPATH**/ ?>